//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
              function Delay() - simple software delay
              function Wait1ms() - 1mS software delay
              function WaitNms() - N ms software delay
              function ConfigurePorts() - provides I/O set up
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r59709    26/06/09    - initial coding

     ******************************************************
     * File created by: Freescale  MSG Applications Group *
     ******************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12HY64.h>     /* derivative information */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : Sets up the PWM channels 0 - 3 to with different alignment
               : and polarity settings and 50% duty cycle. The user can observe
               : this by probing the channel pins.
******************************************************************************/
void main(void)
{
	EnableInterrupts;

  PTPRRL = 0x0F; // Route PWM3:0 from PP3:0 to PS7:4

  /*************************/
  PWMCAE = 0x0C; //Set center alignment for channels 0 - 3
  PWMPOL = 0x0A; //Set polarity for channels 0 - 3
  //The above register setting should match the following truth table  .
  //PWM0: Center Aligned=0, Polarity=0
  //PWM1: Center Aligned=0, Polarity=1
  //PWM2: Center Aligned=1, Polarity=0
  //PWM3: Center Aligned=1, Polarity=1
  /*************************/  
  
  PWMPER0 = 0xFF; //Set chan 0 period length to the maximum.
  PWMPER1 = 0xFF; //Set chan 1 period length to the maximum.
  PWMPER2 = 0xFF; //Set chan 2 period length to the maximum.
  PWMPER3 = 0xFF; //Set chan 3 period length to the maximum.

  PWMDTY0 = 0x80; //Set chan 0 duty cycle to half the maximum, 50%.
  PWMDTY1 = 0x80; //Set chan 1 duty cycle to half the maximum, 50%.
  PWMDTY2 = 0x80; //Set chan 2 duty cycle to half the maximum, 50%.
  PWMDTY3 = 0x80; //Set chan 3 duty cycle to half the maximum, 50%.

  PWME = 0x0F;    //Enable PWM channels 0 - 3
  
  for(;;);
  /* PLEASE MAKE SURE THAT YOU NEVER EXIT main(void) */
}
